unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Borland.Vcl.StdCtrls, Borland.Vcl.ComCtrls, Borland.Vcl.ExtCtrls,
  Borland.Vcl.FileCtrl, System.ComponentModel, cd, MMSystem;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    DriveComboBox1: TDriveComboBox;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Panel2: TPanel;
    TrackBar3: TTrackBar;
    TrackBar4: TTrackBar;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Edit1: TEdit;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    TrackBar2: TTrackBar;
    TrackBar1: TTrackBar;
    Panel1: TPanel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Button13: TButton;
    OpenDialog1: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
if not OpenCD(DriveComboBox1.Drive+':') then ShowMessage('Operacja nie powiosa si');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
if CloseCD(DriveComboBox1.Drive+':') then ShowMessage('Operacja nie powiosa si');
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
if IsCDAudio(DriveComboBox1.Drive+':')
  then ShowMessage('Napd '+DriveComboBox1.Drive+': zawiera pyt audio')
  else ShowMessage('Napd '+DriveComboBox1.Drive+': nie zawiera pyty audio');
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
if not IsCDAudio(DriveComboBox1.Drive+':')
  then ShowMessage('Napd '+DriveComboBox1.Drive+': nie zawiera pyty audio')
  else PlayCDAudio(DriveComboBox1.Drive+':');
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
if not IsCDAudio(DriveComboBox1.Drive+':')
  then ShowMessage('Napd '+DriveComboBox1.Drive+': nie zawiera pyty audio')
  else PauseCDAudio(DriveComboBox1.Drive+':');
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
if not IsCDAudio(DriveComboBox1.Drive+':')
  then ShowMessage('Napd '+DriveComboBox1.Drive+': nie zawiera pyty audio')
  else ResumeCDAudio(DriveComboBox1.Drive+':');
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
if not IsCDAudio(DriveComboBox1.Drive+':')
  then ShowMessage('Napd '+DriveComboBox1.Drive+': nie zawiera pyty audio')
  else StopCDAudio(DriveComboBox1.Drive+':');
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
case StanCDAudio(DriveComboBox1.Drive+':') of
  1242732: ShowMessage('Brak napdu CD');
  530: ShowMessage('Brak pyty');
  525: ShowMessage('Zatrzymany');
  526: ShowMessage('Odtwarzanie');
  else
  ShowMessage(IntToStr(StanCDAudio(DriveComboBox1.Drive+':')));
  end;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
OpenDialog1.FileName:=Edit1.Text;
if OpenDialog1.Execute then Edit1.Text:=OpenDialog1.FileName;
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
PlaySound(Edit1.Text,0,SND_FILENAME or SND_ASYNC);
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
PlaySound(nil,0,0);
end;

procedure TForm1.Button12Click(Sender: TObject);
begin
  if waveOutGetNumDevs=0
    then ShowMessage('Brak karty dwikowej')
    else ShowMessage('Karty dwikowa jest zainstalowana');
end;

procedure UstalPoziomGlosnosciWave(kanalLewy,kanalPrawy :Byte);
begin
waveoutSetVolume(WAVE_MAPPER, Integer((kanalLewy shl 24) or (kanalPrawy shl 8)));
end;

procedure CzytajPoziomGlosnosciWave(var kanalLewy :Byte;var kanalPrawy :Byte);
var glosnosc :Cardinal;
begin
//waveoutGetVolume(WAVE_MAPPER,@glosnosc); //Win32
waveoutGetVolume(WAVE_MAPPER,glosnosc); //.NET
kanalLewy:=Byte(glosnosc shr 24);
kanalPrawy:=Byte(glosnosc shr 8);
end;

function modelBalansu(balans :Byte) :Double;
begin
if balans<127 then Result:=(2.0*balans)/255.0
              else Result:=1.0;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
var
  lewy,prawy :Byte;
  glosnosc,balans :Byte;
begin
//Kanay
if RadioButton1.Checked then
  begin
  lewy:=TrackBar1.Position;
  prawy:=TrackBar2.Position;
  end;

//Gono, balans
if RadioButton2.Checked then
  begin
  glosnosc:=TrackBar1.Position;
  balans:=TrackBar2.Position;
  lewy:=Round(glosnosc*(modelBalansu(255-balans)));
  prawy:=Round(glosnosc*(modelBalansu(balans)));
  end;

UstalPoziomGlosnosciWave(lewy,prawy);

Button13Click(Sender); //wyswietlanie poziomu glosnosci
end;

procedure TForm1.Button13Click(Sender: TObject);
var lewy,prawy :Byte;
begin
CzytajPoziomGlosnosciWave(lewy,prawy);
Label3.Caption:=IntToStr(lewy);
Label5.Caption:=IntToStr(prawy);
end;

procedure TForm1.FormCreate(Sender: TObject);
var lewy,prawy :Byte;
begin
Button13Click(Sender);

CzytajPoziomGlosnosciWave(lewy,prawy);
TrackBar1.Position:=lewy;
TrackBar2.Position:=prawy;

CzytajPoziomGlosnosciCDAudio(lewy,prawy);
TrackBar3.Position:=lewy;
TrackBar4.Position:=prawy;
end;

procedure TForm1.TrackBar3Change(Sender: TObject);
begin
UstalPoziomGlosnosciCDAudio(TrackBar3.Position,TrackBar4.Position);
end;

end.
